/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.BlockGroupAllocation;
import DE.siemens.ad.logo.model.Hardware;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class ProgrammingLanguage {
    protected BlockGroupAllocation fBlockGroupAllocation;

    public Vector[] getAvailableBlocks(Hardware hardware) {
        return hardware.getAvailableBlocks();
    }

    public abstract BlockGroup getAvailableBlockGroups(Hardware var1);

    protected List getAllBlockNames(String[][] blockNames) {
        ArrayList<String> blockNameVector = new ArrayList<String>();
        for (int i = 0; i < blockNames.length; ++i) {
            for (int j = 1; j < blockNames[i].length; ++j) {
                blockNameVector.add(blockNames[i][j]);
            }
        }
        return blockNameVector;
    }

    public abstract String getName();

    public abstract List getAvailableBlockNames(Hardware var1);

    protected List getAllBlocks(Vector[] blockVectorArray) {
        ArrayList blocks = new ArrayList();
        for (int i = 0; i < blockVectorArray.length; ++i) {
            Vector blockVector = blockVectorArray[i];
            for (int j = 1; j < blockVector.size(); ++j) {
                blocks.add(blockVector.elementAt(j));
            }
        }
        return blocks;
    }

    public boolean isRightTerminal(Block block) {
        return false;
    }

    public boolean isBlockAvailable(Block block, Hardware hardware) {
        if (hardware.supports(block.getName())) {
            return true;
        }
        return this.getAvailableBlockNames(hardware).contains(block.getName());
    }

    public boolean isBinaryInConnectorMultiConnectable() {
        return false;
    }

    public boolean isAnalogInConnectorMultiConnectable() {
        return false;
    }

    public boolean isInConnectorNegatable() {
        return false;
    }

    public String getBlockNumberPrefix(Block block) {
        return "B";
    }

    public BlockGroupAllocation getBlockGroupAllocation() {
        return this.fBlockGroupAllocation;
    }

    public String toString() {
        return this.getName() + super.toString();
    }

    protected void setHardware(BlockGroup blockGroup, Hardware hardware) {
        for (Object element : blockGroup.getBlocks()) {
            if (element instanceof BlockGroup) {
                this.setHardware((BlockGroup)element, hardware);
            }
            if (!(element instanceof Block)) continue;
            ((Block)element).setHardware(hardware);
        }
    }
}

